/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.tile;

import gloridifice.watersource.client.render.tile.AnimationTile;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RainCollectorTile
extends AnimationTile
implements ITickableTileEntity {
    LazyOptional<FluidTank> tank = LazyOptional.of(this::createFluidHandler);
    public int capacity;
    private int processTicks = 0;
    int heightAmount;

    public RainCollectorTile(int capability) {
        super(TileEntityTypesRegistry.RAIN_COLLECTOR);
        this.capacity = capability;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.tank.ifPresent(fluidTank -> fluidTank.readFromNBT(compound.func_74775_l("tank")));
        this.processTicks = ((IntNBT)compound.func_74781_a("processTicks")).func_150287_d();
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.tank.ifPresent(fluidTank -> compound.func_218657_a("tank", (INBT)fluidTank.writeToNBT(new CompoundNBT())));
        compound.func_218657_a("processTicks", (INBT)IntNBT.func_229692_a_((int)this.processTicks));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (!this.field_145846_f && CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.equals(cap)) {
            return this.tank.cast();
        }
        return super.getCapability(cap, side);
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                RainCollectorTile.this.refresh();
                RainCollectorTile.this.func_70296_d();
                super.onContentsChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getAttributes().isLighterThanAir() && stack.getFluid().getAttributes().getTemperature() < 500;
            }
        };
    }

    public LazyOptional<FluidTank> getTank() {
        return this.tank;
    }

    public int getFluidAmount() {
        return ((FluidTank)this.tank.orElse(null)).getFluidAmount();
    }

    private void updateHeight() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            if (this.heightAmount > this.getFluidAmount()) {
                this.heightAmount -= Math.max(1, (this.heightAmount - this.getFluidAmount()) / 10);
            } else if (this.heightAmount < this.getFluidAmount()) {
                this.heightAmount += Math.max(1, (this.getFluidAmount() - this.heightAmount) / 10);
            }
        }
    }

    public float getHeight() {
        this.updateHeight();
        return 0.75f * (float)this.heightAmount / (float)this.capacity;
    }

    public void func_73660_a() {
        ++this.processTicks;
        this.processTicks %= 2000;
        if (this.func_145831_w().func_72896_J() && this.processTicks % 5 == 0 && RainCollectorTile.hasBlockOnSelf(this.field_145850_b, this.field_174879_c)) {
            this.tank.ifPresent(tank -> tank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    public static boolean hasBlockOnSelf(World world, BlockPos pos) {
        boolean bool = true;
        for (int i = 1; i <= world.func_217301_I(); ++i) {
            bool = bool && world.func_175623_d(pos.func_177981_b(i));
        }
        return bool;
    }
}

